<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$allowedUrls = [
    'https://cloud8.vsgtech.co/8024/stream,
    'https://cloud8.vsgtech.co/8024/stream',
    'https://cloud8.vsgtech.co/8024/stream',
];

// Clave API de Last.fm
define('LASTFM_API_KEY', 'dd0b2a45222c6988b3a8e9205f1afa0f');

// === Función de caché de respuesta (5 segundos) ===
function getCachedResponse($cacheFile, $ttl = 5) {
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $ttl) {
        return file_get_contents($cacheFile);
    }
    return false;
}

function saveCacheResponse($cacheFile, $data) {
    file_put_contents($cacheFile, $data);
}

// Obtener duración desde Last.fm
function getDurationFromLastFM($artist, $track) {
    $url = "https://ws.audioscrobbler.com/2.0/?method=track.getInfo&api_key=" . LASTFM_API_KEY . "&artist=" . urlencode($artist) . "&track=" . urlencode($track) . "&format=json";
    $response = @file_get_contents($url);
    if (!$response) return 0;

    $data = json_decode($response, true);
    if (isset($data['track']['duration'])) {
        $durationMs = (int) $data['track']['duration'];
        return $durationMs > 0 ? $durationMs / 1000 : 0;
    }

    return 0;
}

// Obtener título de la canción del stream
function getMp3StreamTitle($streamingUrl, $interval) {
    $needle = 'StreamTitle=';
    $headers = [
        'Icy-MetaData: 1',
        'User-Agent: Mozilla/5.0'
    ];

    $context = stream_context_create([
        'http' => [
            'header' => implode("\r\n", $headers),
            'timeout' => 60
        ]
    ]);

    $stream = @fopen($streamingUrl, 'r', false, $context);
    if ($stream === false) return null;

    $metaDataInterval = null;
    foreach ($http_response_header as $header) {
        if (stripos($header, 'icy-metaint') !== false) {
            $metaDataInterval = (int)trim(explode(':', $header)[1]);
            break;
        }
    }

    if ($metaDataInterval === null) {
        fclose($stream);
        return null;
    }

    while (!feof($stream)) {
        fread($stream, $metaDataInterval);
        $buffer = fread($stream, $interval);
        $titleIndex = strpos($buffer, $needle);
        if ($titleIndex !== false) {
            $title = substr($buffer, $titleIndex + strlen($needle));
            $title = substr($title, 0, strpos($title, ';'));
            fclose($stream);
            return trim($title, "' ");
        }
    }

    fclose($stream);
    return null;
}

// Extraer artista y canción
function extractArtistAndSong($title) {
    $title = trim($title, "'");
    if (strpos($title, '-') !== false) {
        [$artist, $song] = explode('-', $title, 2);
        return [trim($artist), trim($song)];
    }
    return ['', trim($title)];
}

// Historial de canciones
function updateHistory($url, $artist, $song) {
    $historyFile = 'history_' . md5($url) . '.json';
    $historyLimit = 10;

    if (!file_exists($historyFile)) {
        $history = [];
    } else {
        $history = json_decode(file_get_contents($historyFile), true);
        if ($history === null) $history = [];
    }

    $currentSong = ["title" => $song, "artist" => $artist];
    $existingIndex = array_search($currentSong, array_column($history, 'song'));
    if ($existingIndex !== false) {
        array_splice($history, $existingIndex, 1);
    }

    array_unshift($history, ["song" => $currentSong]);
    $history = array_slice($history, 0, $historyLimit);
    file_put_contents($historyFile, json_encode($history));

    return $history;
}

// INICIO
header('Content-Type: application/json');

$url = $_GET['url'] ?? '';
$interval = isset($_GET['interval']) ? (int)$_GET['interval'] : 19200;

// Validaciones básicas
if (!filter_var($url, FILTER_VALIDATE_URL)) {
    echo json_encode(["error" => "Invalid URL"]);
    exit;
}

if (!in_array($url, $allowedUrls)) {
    echo json_encode([
        "title" => "URL BLOQUEADA",
        "artist" => "CONTACTENOS: +51975959016",
        "artwork" => "https://nexostreaming.com/wp-content/uploads/2025/02/bloqueada.png"
    ]);
    exit;
}

// Ruta de caché
$cacheFile = 'cache_' . md5($url) . '.json';
$cached = getCachedResponse($cacheFile, 5); // 5 segundos TTL
if ($cached !== false) {
    echo $cached;
    exit;
}

// Continuar si no hay cache
$start_time_file = 'start_time_' . md5($url) . '.txt';
$previous_song_file = 'previous_song_' . md5($url) . '.txt';

$previous_song = file_exists($previous_song_file) ? file_get_contents($previous_song_file) : null;
$start_time = file_exists($start_time_file) ? (int)file_get_contents($start_time_file) : time();
if (!file_exists($start_time_file)) file_put_contents($start_time_file, $start_time);

// Obtener metadatos
$title = getMp3StreamTitle($url, $interval);
if (!$title) {
    echo json_encode(["error" => "No se pudo recuperar el título de la transmisión"]);
    exit;
}

[$artist, $song] = extractArtistAndSong($title);

if ($song !== $previous_song) {
    $start_time = time();
    file_put_contents($start_time_file, $start_time);
    file_put_contents($previous_song_file, $song);
}

$duration = getDurationFromLastFM($artist, $song);
if ($duration === 0) $duration = 180;

$elapsed = time() - $start_time;
$elapsed = min($elapsed, $duration);
$remaining = max(0, $duration - $elapsed);

$elapsed = (int)$elapsed;
$remaining = (int)$remaining;
$duration = (int)$duration;

$history = updateHistory($url, $artist, $song);
$filteredHistory = array_slice($history, 1);

// === Generar respuesta final ===
 $response = [
        "songtitle" => "$artist - $song",
        "artist" => $artist,
        "song" => $song,
        "source" => $url,
  
        "song_history" => $filteredHistory,
        "now_playing" => [
            "elapsed" => $elapsed,   // Elapsed como entero
            "remaining" => $remaining, // Remaining como entero
            "duration" => $duration   // Duration como entero
        ]
    ];

$jsonResponse = json_encode($response);
saveCacheResponse($cacheFile, $jsonResponse);
echo $jsonResponse;
